/*
 * Decompiled with CFR 0.152.
 */
package org.opensc.pkcs11;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.Provider;
import java.security.ProviderException;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensc.pkcs11.spec.PKCS11DSAKeyPairGenParameterSpec;
import org.opensc.pkcs11.spec.PKCS11RSAKeyPairGenParameterSpec;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11SessionChild;
import org.opensc.util.DestroyableHolder;
import org.opensc.util.DestroyableParent;

public class PKCS11Provider
extends Provider
implements DestroyableParent {
    private static final Log log = LogFactory.getLog(PKCS11Provider.class);
    private static final long serialVersionUID = -2568219416560640437L;
    private static final double version = 0.4;
    private static final double patchlevel = 0.0;
    private long pkcs11ModuleHandle = 0L;
    private ShutdownThread shutdownThread;
    private DestroyableHolder destroyableHolder;

    private native long loadNativePKCS11Module(String var1) throws PKCS11Exception;

    private native void unloadPKCS11Module(long var1) throws PKCS11Exception;

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    public synchronized void cleanup() {
        if (this.pkcs11ModuleHandle != 0L) {
            try {
                this.destroyableHolder.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                log.error((Object)"Failure during destruction of C resources:", (Throwable)destroyFailedException);
            }
            try {
                this.unloadPKCS11Module(this.pkcs11ModuleHandle);
            }
            catch (PKCS11Exception pKCS11Exception) {
                log.error((Object)"Failure unloading PKCS#11 module:", (Throwable)pKCS11Exception);
            }
            this.pkcs11ModuleHandle = 0L;
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
                this.shutdownThread = null;
            }
        }
    }

    private synchronized void deregisterSutdownThread() {
        this.shutdownThread = null;
    }

    private void initialize(String string) throws IOException {
        this.pkcs11ModuleHandle = this.loadNativePKCS11Module(string);
        this.destroyableHolder = new DestroyableHolder();
        this.shutdownThread = new ShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        this.putService(new PKCS11Service(this, "KeyStore", "PKCS11", "org.opensc.pkcs11.spi.PKCS11KeyStoreSpi"));
        this.putService(new PKCS11SignatureService(this, "Signature", "NONEwithRSA", "org.opensc.pkcs11.spi.PKCS11SignatureSpi"));
        this.putService(new PKCS11SignatureService(this, "Signature", "MD5withRSA", "org.opensc.pkcs11.spi.PKCS11SignatureSpi"));
        this.putService(new PKCS11SignatureService(this, "Signature", "SHA1withRSA", "org.opensc.pkcs11.spi.PKCS11SignatureSpi"));
        this.putService(new PKCS11SignatureService(this, "Signature", "SHA256withRSA", "org.opensc.pkcs11.spi.PKCS11SignatureSpi"));
        this.putService(new PKCS11SignatureService(this, "Signature", "SHA384withRSA", "org.opensc.pkcs11.spi.PKCS11SignatureSpi"));
        this.putService(new PKCS11SignatureService(this, "Signature", "SHA512withRSA", "org.opensc.pkcs11.spi.PKCS11SignatureSpi"));
        this.putService(new PKCS11SignatureService(this, "Signature", "SHA1withDSA", "org.opensc.pkcs11.spi.PKCS11SignatureSpi"));
        this.putService(new PKCS11SignatureService(this, "Signature", "NONEwithDSA", "org.opensc.pkcs11.spi.PKCS11SignatureSpi"));
        this.putService(new PKCS11CipherService(this, "Cipher", "RSA/ECB/PKCS1Padding", "org.opensc.pkcs11.spi.PKCS11CipherSpi"));
        this.putService(new PKCS11KeyPairGeneratorService(this, "KeyPairGenerator", "RSA", "org.opensc.pkcs11.spi.PKCS11KeyPairGeneratorSpi"));
        this.putService(new PKCS11KeyPairGeneratorService(this, "KeyPairGenerator", "DSA", "org.opensc.pkcs11.spi.PKCS11KeyPairGeneratorSpi"));
    }

    public PKCS11Provider(String string) throws IOException {
        super("OpenSC-PKCS11", 0.4, "OpenSC PKCS11 provider.");
        this.initialize(string);
    }

    public PKCS11Provider(String string, String string2) throws IOException {
        super("OpenSC-PKCS11-" + string2, 0.4, "OpenSC PKCS11 provider.");
        this.initialize(string);
    }

    public long getPkcs11ModuleHandle() {
        return this.pkcs11ModuleHandle;
    }

    @Override
    public void register(Destroyable destroyable) {
        this.destroyableHolder.register(destroyable);
    }

    @Override
    public void deregister(Destroyable destroyable) {
        this.destroyableHolder.deregister(destroyable);
    }

    static {
        String string = System.getProperty("os.arch");
        System.loadLibrary("opensc-PKCS11-" + string);
    }

    private static class PKCS11KeyPairGeneratorService
    extends PKCS11Service {
        PKCS11KeyPairGeneratorService(Provider provider, String string, String string2, String string3) {
            super(provider, string, string2, string3);
        }

        @Override
        public boolean supportsParameter(Object object) {
            if (object instanceof PKCS11RSAKeyPairGenParameterSpec) {
                return super.getAlgorithm().equals("RSA");
            }
            if (object instanceof PKCS11DSAKeyPairGenParameterSpec) {
                return super.getAlgorithm().equals("DSA");
            }
            return false;
        }
    }

    private static class PKCS11CipherService
    extends PKCS11Service {
        PKCS11CipherService(Provider provider, String string, String string2, String string3) {
            super(provider, string, string2, string3);
        }

        @Override
        public boolean supportsParameter(Object object) {
            if (!(object instanceof PKCS11SessionChild)) {
                return false;
            }
            if (object instanceof RSAKey) {
                return super.getAlgorithm().startsWith("RSA");
            }
            return false;
        }
    }

    private static class PKCS11SignatureService
    extends PKCS11Service {
        PKCS11SignatureService(Provider provider, String string, String string2, String string3) {
            super(provider, string, string2, string3);
        }

        @Override
        public boolean supportsParameter(Object object) {
            if (!(object instanceof PKCS11SessionChild)) {
                return false;
            }
            if (object instanceof RSAKey) {
                return super.getAlgorithm().endsWith("RSA");
            }
            if (object instanceof DSAKey) {
                return super.getAlgorithm().endsWith("DSA");
            }
            return false;
        }
    }

    private static class PKCS11Service
    extends Provider.Service {
        private static final Class[] paramTypes = new Class[]{PKCS11Provider.class, String.class};

        PKCS11Service(Provider provider, String string, String string2, String string3) {
            super(provider, string, string2, string3, null, null);
        }

        @Override
        public Object newInstance(Object object) {
            try {
                PKCS11Provider pKCS11Provider = (PKCS11Provider)this.getProvider();
                ClassLoader classLoader = pKCS11Provider.getClass().getClassLoader();
                Class<?> clazz = classLoader == null ? Class.forName(this.getClassName()) : classLoader.loadClass(this.getClassName());
                Constructor<?> constructor = clazz.getConstructor(paramTypes);
                Object obj = constructor.newInstance(pKCS11Provider, this.getAlgorithm());
                return obj;
            }
            catch (Exception exception) {
                throw new ProviderException("Caught exception in newInstance:", exception);
            }
        }
    }

    private class ShutdownThread
    extends Thread {
        private final PKCS11Provider provider;

        ShutdownThread(PKCS11Provider pKCS11Provider2) {
            this.provider = pKCS11Provider2;
        }

        @Override
        public void run() {
            this.provider.deregisterSutdownThread();
            this.provider.cleanup();
        }
    }
}

