/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPXMLApplicationProfileParser;
import de.cardcontact.scdp.gp.GPXMLParser;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.xml.sax.helpers.DefaultHandler;

public class GPXML
extends ScriptableObject {
    static final String clazzName = "GPXML";
    private GPXMLParser gpParser;

    public String getClassName() {
        return clazzName;
    }

    public GPXML() {
    }

    public GPXML(Scriptable scope) {
        this.gpParser = new GPXMLParser(scope);
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"GPXML() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 0, 0);
        GPXML g = new GPXML((Scriptable)ctorObj);
        return g;
    }

    public static void jsFunction_defineArrayElement(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        String path = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        String arrayElement = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        String arrayIndex = ArgChecker.getString(thisObj, clazzName, args, 2, "#");
        GPXML g = (GPXML)thisObj;
        g.gpParser.defineArrayElement(path, arrayElement, arrayIndex);
    }

    public static void jsFunction_defineScriptElement(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        String path = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        boolean asFunction = ArgChecker.getBoolean(thisObj, clazzName, args, 1, true);
        GPXML g = (GPXML)thisObj;
        g.gpParser.defineScriptElement(path, asFunction);
    }

    private static Scriptable parse(Scriptable scope, GPXMLParser ph, InputStream is) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)ph);
        }
        catch (JavaScriptException jse) {
            throw jse;
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(scope, clazzName, 36, 0, "XML Error: " + e.getMessage());
        }
        return ph.getRoot();
    }

    private static Scriptable parse(Scriptable scope, GPXMLParser ph, String profile) {
        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(scope);
        String filename = gpr.mapFilename(profile, 6);
        if (filename == null) {
            GPError.throwAsGPErrorEx(scope, clazzName, 23, 1, "File " + profile + " not found");
        }
        ph.setFilename(filename);
        InputStream is = null;
        try {
            is = gpr.openFileResource(filename);
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx(scope, clazzName, 23, 1, "File " + filename + " can not be opened");
        }
        return GPXML.parse(scope, ph, is);
    }

    public static Scriptable parse(Scriptable scope, String profile) {
        GPXMLParser ph = new GPXMLParser(scope);
        ph.setFilename(profile);
        return GPXML.parse(scope, ph, profile);
    }

    public static Scriptable parse(Scriptable scope, GPXMLParser ph, byte[] bs) {
        ByteArrayInputStream bais;
        InputStream is = bais = new ByteArrayInputStream(bs);
        try {
            if (bs[0] == 31 && bs[1] == -117) {
                is = new GZIPInputStream(bais);
            }
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx(scope, clazzName, 36, 0, "ZIP Error: " + e.getMessage());
        }
        return GPXML.parse(scope, ph, is);
    }

    public static Scriptable parseApplicationProfile(Scriptable scope, String profile) {
        GPXMLApplicationProfileParser ph = new GPXMLApplicationProfileParser(scope);
        ph.setFilename(profile);
        ph.addRootArrayElement("Key", "Name");
        ph.addRootArrayElement("DataElement", "Name");
        ph.addRootArrayElement("Function", "Name");
        ph.addRootArrayElement("ScriptFragment", "Name");
        return GPXML.parse(scope, (GPXMLParser)ph, profile);
    }

    public static Scriptable jsStaticFunction_parse(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        GPXMLParser ph = new GPXMLParser(thisObj);
        if (args[0] instanceof ByteString) {
            ByteString bs = (ByteString)((Object)args[0]);
            return GPXML.parse(thisObj, ph, bs.getBytes());
        }
        return GPXML.parse(thisObj, ph, Context.toString((Object)args[0]));
    }

    public static Scriptable jsFunction_parse(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        GPXML g = (GPXML)thisObj;
        if (args[0] instanceof ByteString) {
            ByteString bs = (ByteString)((Object)args[0]);
            return GPXML.parse(thisObj, g.gpParser, bs.getBytes());
        }
        if (args[0] instanceof NativeJavaObject) {
            NativeJavaObject njo = (NativeJavaObject)args[0];
            InputStream is = (InputStream)njo.unwrap();
            return GPXML.parse(thisObj, g.gpParser, is);
        }
        return GPXML.parse(thisObj, g.gpParser, Context.toString((Object)args[0]));
    }

    public static Scriptable jsStaticFunction_parseApplicationProfile(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        return GPXML.parseApplicationProfile(thisObj, Context.toString((Object)args[0]));
    }

    public static Object getObject(Scriptable start, String path) {
        Object current = start;
        StringTokenizer st = new StringTokenizer(path, ".");
        while (st.hasMoreTokens()) {
            String property = st.nextToken();
            if (!(current instanceof Scriptable)) {
                return null;
            }
            Scriptable n = current;
            if ((current = n.get(property, n)) != null && current != Scriptable.NOT_FOUND) continue;
            return null;
        }
        return current;
    }

    public static int getObjectAsToken(Scriptable start, String path, String tokenlist) {
        Object o = GPXML.getObject(start, path);
        if (o == null) {
            return -1;
        }
        String value = o.toString();
        StringTokenizer st = new StringTokenizer(tokenlist, ",");
        int index = 0;
        int found = -1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (value.equals(token)) {
                found = index;
                break;
            }
            ++index;
        }
        return found;
    }

    public static int getObjectAsToken(Scriptable start, String path, String[] tokenlist) {
        int index;
        Object o = GPXML.getObject(start, path);
        if (o == null) {
            return -1;
        }
        String value = o.toString();
        for (index = tokenlist.length - 1; index >= 0 && !value.equals(tokenlist[index]); --index) {
        }
        return index;
    }

    public static ByteString getByteString(Scriptable node) {
        Object o = node.get("Value", node);
        if (o == null || o == Scriptable.NOT_FOUND) {
            return null;
        }
        String value = Context.toString((Object)o);
        int encoding = GPXML.getObjectAsToken(node, "Encoding", new String[]{"HEX", "UTF8", "ASCII", "BASE64"});
        switch (encoding) {
            case 1: {
                encoding = 2;
                break;
            }
            case 2: {
                encoding = 3;
                break;
            }
            case 3: {
                encoding = 4;
                break;
            }
            default: {
                encoding = 16;
            }
        }
        Object[] args = new Object[]{value, new Integer(encoding)};
        return (ByteString)Context.getCurrentContext().newObject(node, "ByteString", args);
    }

    public static boolean getBooleanProperty(Scriptable node, String name, boolean defaultValue) {
        Object o = node.get(name, node);
        boolean returnValue = defaultValue;
        if (o != null && o != Scriptable.NOT_FOUND) {
            if (o instanceof CharSequence) {
                String value = ((CharSequence)o).toString();
                returnValue = value.equalsIgnoreCase("true");
            } else {
                returnValue = Context.toBoolean((Object)o);
            }
        }
        return returnValue;
    }

    public static String getStringProperty(Scriptable node, String name, String defaultValue) {
        Object o = node.get(name, node);
        String returnValue = defaultValue;
        if (o != null && o != Scriptable.NOT_FOUND) {
            returnValue = Context.toString((Object)o);
        }
        return returnValue;
    }

    public static int getIntegerProperty(Scriptable node, String name, int defaultValue) {
        Object o = node.get(name, node);
        int returnValue = defaultValue;
        if (o != null && o != Scriptable.NOT_FOUND) {
            returnValue = (int)Context.toNumber((Object)o);
        }
        return returnValue;
    }
}

