/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import java.security.cert.Certificate;

public class SmartCardHSMEntry {
    private SmartCardHSMKey key = null;
    private Certificate[] certs = null;
    private boolean isEECertificate;
    private byte id;

    public SmartCardHSMEntry(SmartCardHSMKey key) {
        this.key = key;
        this.id = key.getKeyRef();
    }

    public SmartCardHSMEntry(Certificate cert, boolean isEECertificate, byte id) {
        this.certs = new Certificate[]{cert};
        this.isEECertificate = isEECertificate;
        this.setId(id);
    }

    public SmartCardHSMEntry(Certificate[] certs, boolean isEECertificate, byte id) {
        this.certs = certs;
        this.isEECertificate = isEECertificate;
        this.setId(id);
    }

    public boolean isEECertificate() {
        return this.isEECertificate;
    }

    public boolean isCertificateEntry() {
        return this.certs != null;
    }

    public boolean isKeyEntry() {
        return this.key != null;
    }

    public SmartCardHSMKey getKey() {
        return this.key;
    }

    public void setKey(SmartCardHSMKey key) {
        this.key = key;
    }

    public void setCert(Certificate cert, boolean isEECertificate, byte id) {
        this.certs = new Certificate[]{cert};
        this.isEECertificate = isEECertificate;
        this.id = id;
    }

    public void setCertChain(Certificate[] cert, byte id) {
        this.certs = cert;
        this.isEECertificate = true;
        this.id = id;
    }

    public Certificate getCert() {
        if (this.certs == null) {
            return null;
        }
        return this.certs[0];
    }

    public Certificate[] getCertChain() {
        return this.certs;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }
}

