/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.scdp.scsh3.GUIShell;
import de.cardcontact.scdp.scsh3.Task;
import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.mozilla.javascript.Scriptable;

public class TaskCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    HashMap<String, Icon> iconCache = new HashMap();

    protected Icon getCachedIcon(String name) {
        String keyname = name.toLowerCase();
        Icon icon = this.iconCache.get(keyname);
        if (icon != null) {
            return icon;
        }
        ImageIcon imageIcon = null;
        try {
            imageIcon = GUIShell.loadImageIcon(GUIShell.instance.getClass(), name + ".png");
            this.iconCache.put(keyname, imageIcon);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return imageIcon;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Task) {
            Task task = (Task)value;
            String iconName = task.getIcon();
            Icon icon = null;
            if (iconName != null) {
                icon = this.getCachedIcon(iconName);
            }
            this.setIcon(icon);
            this.setText(task.getMessage());
            if (task.has("tooltip", (Scriptable)task)) {
                String tooltip = (String)task.get("tooltip", (Scriptable)task);
                this.setToolTipText(tooltip);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
        return null;
    }
}

