/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.scdp.scsh3.GUIShell;
import de.cardcontact.scdp.scsh3.OutlineNodeRendererSupport;
import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class OutlineNodeRenderer
extends DefaultTreeCellRenderer {
    HashMap iconCache = new HashMap();

    protected Icon getCachedIcon(String name) {
        String keyname = name.toLowerCase();
        Object o = this.iconCache.get(keyname);
        if (o != null) {
            return (Icon)o;
        }
        ImageIcon icon = null;
        try {
            icon = GUIShell.loadImageIcon(GUIShell.instance.getClass(), name + ".png");
            this.iconCache.put(keyname, icon);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return icon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof OutlineNodeRendererSupport) {
            Icon icon;
            OutlineNodeRendererSupport node = (OutlineNodeRendererSupport)value;
            String iconName = node.getIcon();
            if (iconName != null && (icon = this.getCachedIcon(iconName)) != null) {
                this.setIcon(icon);
            }
            this.setToolTipText(node.getToolTip());
        } else {
            this.setToolTipText(null);
        }
        return this;
    }
}

