/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.scsh3;

import de.cardcontact.scdp.scsh3.GUIShell;
import de.cardcontact.scdp.scsh3.JSFilter;
import de.cardcontact.scdp.scsh3.Preferences;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class Launcher
extends JDialog
implements ActionListener,
ItemListener {
    private GUIShell parent = null;
    private JButton ok;
    private JButton browse;
    private JCheckBox showLauncherCheckBox;
    private JCheckBox showScriptSelection;
    private JComboBox comboBox;
    private String lastSelectionResult = null;
    private boolean showLauncher = true;
    private boolean fileSelectionMode = false;
    private JFileChooser fileChoose = new JFileChooser();

    public Launcher() {
        this.initialize();
    }

    public Launcher(GUIShell owner, boolean modal) {
        super((Frame)owner, modal);
        this.parent = owner;
        this.initialize();
        this.setResizable(false);
        this.setLocation(owner.getX() + 100, owner.getY() + 100);
    }

    private void initialize() {
        this.setSize(500, 260);
        this.setTitle("Smart Card Shell Workspace Selection");
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        this.setResizable(false);
        contentPane.setLayout(null);
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.browse = new JButton("Browse...");
        this.browse.addActionListener(this);
        JTextArea text = new JTextArea();
        text.setBackground(this.getBackground());
        Font font = new Font("Arial", 0, 12);
        text.setFont(font);
        text.setEditable(false);
        text.append("\nPlease select your workspace directory or initial configuration script.\n\nWhen selecting a configuration script, then the workspace is determined\nby the directory location of the script.");
        this.comboBox = new JComboBox();
        this.comboBox.setEditable(true);
        this.readConfiguration();
        Insets insets = this.getInsets();
        Dimension size = text.getPreferredSize();
        text.setBounds(insets.left + 10, insets.top + 5, size.width + 10, size.height);
        size = this.comboBox.getPreferredSize();
        this.comboBox.setBounds(insets.left + 10, insets.top + 100, 360, size.height);
        size = this.browse.getPreferredSize();
        this.browse.setBounds(this.comboBox.getBounds().x + this.comboBox.getBounds().width + 10, insets.top + 100, size.width, size.height);
        this.showLauncherCheckBox = new JCheckBox("Use this as the default and do not ask again.");
        this.showLauncherCheckBox.setToolTipText("Enable this option to save your current selection as the default value.");
        size = this.showLauncherCheckBox.getPreferredSize();
        this.showLauncherCheckBox.setBounds(insets.left + 10, insets.top + 130, size.width, size.height);
        this.showScriptSelection = new JCheckBox("Allow selection of a configuration script");
        this.showScriptSelection.setToolTipText("Enable this option if you want to select a startup script. Otherwise only directories are available in the browse dialog.");
        this.showScriptSelection.addItemListener(this);
        size = this.showScriptSelection.getPreferredSize();
        this.showScriptSelection.setBounds(insets.left + 10, insets.top + 150, size.width, size.height);
        size = this.ok.getPreferredSize();
        this.ok.setBounds(insets.left + 200, insets.top + 190, size.width, size.height);
        contentPane.add(text);
        contentPane.add(this.comboBox);
        contentPane.add(this.browse);
        contentPane.add(this.showLauncherCheckBox);
        contentPane.add(this.showScriptSelection);
        contentPane.add(this.ok);
    }

    private void readConfiguration() {
        Preferences p = Preferences.getPreferences();
        if (p.hasPreference("SHOW_LAUNCHER_AGAIN")) {
            this.showLauncher = p.getBooleanPreference("SHOW_LAUNCHER_AGAIN");
        }
        this.parent.setStartupScript(p.getStringPreference("SELECTED_SCRIPT"));
        String recentScriptProperty = p.getStringPreference("RECENT_SCRIPTS");
        StringTokenizer st = new StringTokenizer(recentScriptProperty, ",");
        this.comboBox.removeAllItems();
        while (st.hasMoreTokens()) {
            this.comboBox.addItem(this.makeObj(st.nextToken()));
        }
        this.comboBox.setSelectedItem(p.getStringPreference("SELECTED_SCRIPT"));
        this.comboBox.repaint();
    }

    private void saveConfiguration() {
        Preferences p = Preferences.getPreferences();
        Object recentScripts = new String();
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            recentScripts = this.comboBox.getItemAt(i).toString() + "," + (String)recentScripts;
        }
        Object selectedScript = this.comboBox.getSelectedItem();
        if (selectedScript != null) {
            p.setStringPreference("SELECTED_SCRIPT", selectedScript.toString());
        }
        p.setStringPreference("RECENT_SCRIPTS", (String)recentScripts);
        p.setBooleanPreference("SHOW_LAUNCHER_AGAIN", !this.showLauncherCheckBox.isSelected());
        p.save();
        this.comboBox.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.ok)) {
            this.saveConfiguration();
            Object startupScript = this.comboBox.getSelectedItem();
            if (startupScript == null || startupScript.toString() == "") {
                this.parent.setStartupScript(null);
            } else {
                this.parent.setStartupScript(startupScript.toString());
            }
            this.dispose();
        } else if (e.getSource().equals(this.browse)) {
            int returnVal;
            this.fileChoose.setFileSelectionMode(1);
            if (this.fileSelectionMode) {
                this.fileChoose.setFileSelectionMode(2);
                this.fileChoose.setFileFilter(new JSFilter());
            }
            if (this.lastSelectionResult != null) {
                this.fileChoose.setCurrentDirectory(new File(this.lastSelectionResult));
            }
            if ((returnVal = this.fileChoose.showOpenDialog(this)) == 0) {
                String path = this.fileChoose.getSelectedFile().getAbsolutePath();
                this.comboBox.insertItemAt(this.makeObj(path), 0);
                this.comboBox.setSelectedIndex(0);
                this.lastSelectionResult = path;
                this.validate();
                this.repaint();
            }
        }
    }

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    public boolean isShowLauncher() {
        return this.showLauncher;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showScriptSelection) {
            if (e.getStateChange() == 2) {
                this.fileSelectionMode = false;
            } else if (e.getStateChange() == 1) {
                this.fileSelectionMode = true;
            }
        }
    }
}

