/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.multiunpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.multiunpacker.NextMediaFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NextMediaDialog
extends JDialog
implements ActionListener {
    private static final String NEXTMEDIA_MSG_ID = "nextmedia.msg";
    private static final String NEXTMEDIA_TITLE_ID = "nextmedia.title";
    private static final String BROWSEBTN_ID = "nextmedia.browsebtn";
    private static final String OKBTN_ID = "nextmedia.okbtn";
    private static final String CANCELBTN_ID = "nextmedia.cancelbtn";
    private static final long serialVersionUID = -2551719029962051020L;
    protected JLabel msg;
    protected JTextField path;
    protected JButton browsebtn;
    protected JButton okbtn;
    protected JButton cancelbtn;
    protected String nextmedianame;
    protected String nextmediapath;
    protected String nextmediainput;
    private final Messages messages;
    protected IconsDatabase icons;
    protected Frame owner;

    public NextMediaDialog(InstallerFrame main, String nextmedia) throws HeadlessException {
        this(null, main, nextmedia);
    }

    public NextMediaDialog(Frame owner, InstallerFrame main, String nextmedia) throws HeadlessException {
        this(owner, main.getMessages(), main.getIcons(), nextmedia);
    }

    public NextMediaDialog(Frame owner, Messages messages, IconsDatabase icons, String nextmedia) {
        super(owner, messages.get(NEXTMEDIA_TITLE_ID, new Object[0]), true);
        this.owner = owner;
        this.messages = messages;
        this.icons = icons;
        this.nextmediapath = nextmedia;
        File nextmediafile = new File(this.nextmediapath);
        this.nextmedianame = nextmediafile.getName();
        this.initUI();
    }

    public NextMediaDialog(Frame owner, InstallData idata, String nextmedia) {
        this(owner, idata.getMessages(), null, nextmedia);
    }

    private void initUI() {
        if (this.icons != null) {
            this.msg = LabelFactory.create(this.messages.get(NEXTMEDIA_MSG_ID, new Object[0]), (Icon)this.icons.get("warning"), 2);
            this.browsebtn = ButtonFactory.createButton(this.messages.get(BROWSEBTN_ID, new Object[0]), (Icon)this.icons.get("open"), new Color(230, 230, 230));
            this.okbtn = ButtonFactory.createButton(this.messages.get(OKBTN_ID, new Object[0]), (Icon)this.icons.get("ok"), new Color(230, 230, 230));
            this.cancelbtn = ButtonFactory.createButton(this.messages.get(CANCELBTN_ID, new Object[0]), (Icon)this.icons.get("cancel"), new Color(230, 230, 230));
        } else {
            this.msg = new JLabel(this.messages.get(NEXTMEDIA_MSG_ID, new Object[0]), 2);
            this.browsebtn = new JButton(this.messages.get(BROWSEBTN_ID, new Object[0]));
            this.okbtn = new JButton(this.messages.get(OKBTN_ID, new Object[0]));
            this.cancelbtn = new JButton(this.messages.get(CANCELBTN_ID, new Object[0]));
        }
        this.path = new JTextField(this.nextmediapath);
        this.path.setColumns(40);
        this.browsebtn.addActionListener(this);
        this.okbtn.addActionListener(this);
        this.cancelbtn.addActionListener(this);
        JPanel mainpanel = new JPanel();
        mainpanel.setLayout(new BoxLayout(mainpanel, 3));
        mainpanel.add(this.msg);
        JPanel pathpanel = new JPanel();
        pathpanel.setLayout(new BoxLayout(pathpanel, 2));
        pathpanel.add(this.path);
        pathpanel.add(this.browsebtn);
        pathpanel.add(Box.createHorizontalGlue());
        mainpanel.add(pathpanel);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new BoxLayout(okpanel, 2));
        okpanel.add(Box.createHorizontalGlue());
        okpanel.add(this.okbtn);
        okpanel.add(this.cancelbtn);
        okpanel.add(Box.createHorizontalGlue());
        mainpanel.add(okpanel);
        mainpanel.add(Box.createVerticalGlue());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainpanel, "Center");
        this.pack();
        if (this.owner != null) {
            Dimension mysize = this.getSize();
            Dimension ownersize = this.owner.getSize();
            Point position = this.owner.getLocationOnScreen();
            Point centerposition = new Point();
            centerposition.setLocation(position.getX() + 0.5 * ownersize.getWidth(), position.getY() + 0.5 * ownersize.getHeight());
            Point myposition = new Point();
            myposition.setLocation(centerposition.getX() - 0.5 * mysize.getWidth(), centerposition.getY() - 0.5 * mysize.getHeight());
            this.setLocation(myposition);
        }
    }

    public String getNextMedia() {
        return this.nextmediainput;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option;
        if (e.getSource() == this.browsebtn) {
            JFileChooser fileChooser = this.path.getText() != null ? new JFileChooser(this.path.getText()) : new JFileChooser();
            fileChooser.setFileFilter(new NextMediaFileFilter(this.nextmedianame, this.messages));
            fileChooser.setDialogTitle(this.messages.get("nextmedia.choosertitle", new Object[0]));
            fileChooser.setDialogType(0);
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showOpenDialog(this) == 0) {
                this.nextmediainput = fileChooser.getSelectedFile().getAbsolutePath();
                this.path.setText(this.nextmediainput);
            }
        } else if (e.getSource() == this.okbtn) {
            this.nextmediainput = this.path.getText();
            this.setVisible(false);
        } else if (e.getSource() == this.cancelbtn && (option = JOptionPane.showConfirmDialog(this, this.messages.get("installer.quit.message", new Object[0]), this.messages.get("installer.quit.title", new Object[0]), 0)) == 0) {
            System.exit(-1);
        }
    }
}

